"use strict";

let person = {};
let currentAnswer = 0;
let currentOperation = "";
let rightAnswers = 0;
let wrongAnswers = 0;
let questionNumber = 0;
let numberOfQuestions = 0;
let percent = 0;
let timer;
let totaltimeinseconds;
let startTime, endTime;
let result = 0;
let currentQuestion = 0;
let totalQuestions = 0;
const colorStops = [
    "#FF0000", //1 red
    "#FF3300", //2 red orange
    "#FF6600", //3 orange
    "#FF9900", //4 yellow orange
    "#FFCC00", //5 yellow
    "#CCCC00", //6 yellow green
    "#99CC00", //7 light green
    "#33A300", //8 bright green
    "#008800", //9 lime green 
    "#006600", //10 green
];

function Name() {
    person.fName = document.getElementById("fName").value;
    person.lName = document.getElementById("lName").value;
    person.fullName = function () {
        return this.fName + " " + this.lName;
    };

    if (person.fName && person.lName) {
        document.getElementById("FullName").innerHTML = `${person.fullName()} you're test scores are below:`;
        
        document.getElementById("amount").disabled = false

        document.getElementById("Math").disabled = false
    } else {
        document.getElementById("FullName").innerHTML = "Please enter your full name.";
    }
}

function selectFlashcards() {
    numberOfQuestions = parseInt(document.getElementById("amount").value);

    if (isNaN(numberOfQuestions) || numberOfQuestions < 5 || numberOfQuestions > 20) {
        document.getElementById("flashcards").innerHTML = "Please enter a valid number of questions (between 5 and 20).";
        return;
    }

    const selectedMath = document.getElementById("Math").selectedIndex;

    if (selectedMath === 0) {
        document.getElementById("flashcards").innerHTML = "Select a math operation.";
    } else {
        switch (selectedMath) {
            case 1: currentOperation = "add"; add(); startTimer(); break;
            case 2: currentOperation = "sub"; sub(); startTimer(); break;
            case 3: currentOperation = "mult"; mult(); startTimer(); break;
            case 4: currentOperation = "divi"; divi(); startTimer(); break;
            default:
                document.getElementById("flashcards").innerHTML = "Invalid operation.";
                break;
        }
    }

    currentQuestion = 0;
    totalQuestions = parseInt(document.getElementById("amount").value);
    updateProgress();

}

function add() {
    document.getElementById("userInput").disabled = false;
    document.getElementById("amount").disabled = true;
    document.getElementById("check").disabled = false;
    document.getElementById("next").disaabled = false;

    let value1 = Math.floor(Math.random() * 10) + 1;
    let value2 = Math.floor(Math.random() * 10) + 1;
    currentAnswer = value1 + value2;

    document.getElementById("question").innerHTML = `What is ${value1} + ${value2}?`;
    document.getElementById("userInput").value = "";
    document.getElementById("flashcards").innerHTML = "Enter your answer and click 'Check'.";
}

function sub() {
    document.getElementById("userInput").disabled = false;
    document.getElementById("amount").disabled = true;
    document.getElementById("check").disabled = false;
    document.getElementById("next").disaabled = false;

    let value1 = Math.floor(Math.random() * 10) + 10;
    let value2 = Math.floor(Math.random() * 10);
    currentAnswer = value1 - value2;

    document.getElementById("question").innerHTML = `What is ${value1} - ${value2}?`;
    document.getElementById("userInput").value = "";
    document.getElementById("flashcards").innerHTML = "Enter your answer and click 'Check'.";
}

function mult() {
    document.getElementById("userInput").disabled = false;
    document.getElementById("amount").disabled = true;
    document.getElementById("check").disabled = false;
    document.getElementById("next").disaabled = false;

    let value1 = Math.floor(Math.random() * 10) + 1;
    let value2 = Math.floor(Math.random() * 10) + 1;
    currentAnswer = value1 * value2;

    document.getElementById("question").innerHTML = `What is ${value1} * ${value2}?`;
    document.getElementById("userInput").value = "";
    document.getElementById("flashcards").innerHTML = "Enter your answer and click 'Check'.";
}

function divi() {
    document.getElementById("userInput").disabled = false;
    document.getElementById("amount").disabled = true;
    document.getElementById("check").disabled = false;
    document.getElementById("next").disaabled = false;

    let value1 = Math.floor(Math.random() * 10) + 1;
    let value2 = Math.floor(Math.random() * 9) + 1;
    
    currentAnswer = (value1 / value2).toFixed(2);

    document.getElementById("question").innerHTML = `What is ${value1} / ${value2}? (Rounded to 2 decimal places)`;
    document.getElementById("userInput").value = "";
    document.getElementById("flashcards").innerHTML = "Enter your answer and click 'Check'.";
}

function check() {
    let userInput = document.getElementById("userInput").value.trim();

    if (userInput === "" || isNaN(userInput)) {
        document.getElementById("flashcards").innerHTML = "Input an actual number.";
        return;
    }

    if (parseFloat(userInput) !== parseFloat(currentAnswer)) {
        document.getElementById("flashcards").innerHTML = `❌ Wrong. The correct answer is ${currentAnswer}.`;
        wrongAnswers++;
    } else {
        document.getElementById("flashcards").innerHTML = `✅ Correct! The answer was ${currentAnswer}.`;
        rightAnswers++;
    }

    questionNumber++;
    document.getElementById("wrongAnswers").innerHTML = `Wrong Answers: ${wrongAnswers}`;
    document.getElementById("rightAnswers").innerHTML = `Correct Answers: ${rightAnswers}`;
    document.getElementById("questionNumber").innerHTML = `Question #${questionNumber + 1}`;
    document.getElementById("userInput").disabled = true;
    document.getElementById("next").disabled = false;
    document.getElementById("check").disabled = true;
    

    if (questionNumber === numberOfQuestions) {
        document.getElementById("flashcards").innerHTML = "Congrats! You've completed your flashcards!";
        document.getElementById("check").disabled = true;
        document.getElementById("next").disabled = true;

        percent = (rightAnswers / numberOfQuestions) * 100;
        document.getElementById("percent").innerHTML = `Percentage: ${Math.round(percent)}%`;

        if (percent >= 70) {
            document.getElementById("result").innerHTML = "Passed";
            document.getElementById("result").style.color = "green";
            document.getElementById("result")
        } else if (percent < 70) {
            document.getElementById("result").innerHTML = "Failed";
            document.getElementById("result").style.color = "red";
        }

        document.getElementById("testScore").style.display = "block";
        
        next();
        stopTimer();
        submitQuiz();
        dateDisplay();
    }
    
}

function next() {
    document.getElementById("userInput").disabled = false;
    document.getElementById("next").disabled = true;
    document.getElementById("check").disabled = false;

    if (currentQuestion <= totalQuestions) {
        currentQuestion++;
        updateProgress();
    }

    if (currentQuestion === totalQuestions) {
        document.getElementById("check").disabled = true;
        document.getElementById("next").disabled = true;
        document.getElementById("userInput").disabled = true;
    }

    switch (currentOperation) {
        case "add": add(); break;
        case "sub": sub(); break;
        case "mult": mult(); break;
        case "divi": divi(); break;
    }
}

function updateProgress() {
    let progressPercent = (currentQuestion / totalQuestions) * 100;
    let progressBar = document.getElementById("progress-bar");

    let colorIndex = Math.floor(progressPercent / 10); 
    progressBar.style.backgroundColor = colorStops[colorIndex];

    progressBar.style.width = progressPercent + "%";
    progressBar.textContent = Math.round(progressPercent) + "%";

    if (currentQuestion >= totalQuestions) {
        document.getElementById("check").disabled = true;
    }
    
    checkAchievements(progressPercent);
}

function checkAchievements(progressPercent) {
    let achievementText = ""; 
     if (progressPercent >= 75) {
        achievementText = "🎉 Flashcard Master!";
    } else if (progressPercent >= 50) {
        achievementText = "🏆 Halfway There!";
    } else if (progressPercent >= 25) {
        achievementText = "🚀 Getting Started!";
    }

    document.getElementById("achievement").innerText = achievementText;
}

function startTimer() {
    let hour = 0;
    let minute = 0;
    let second = 30;
    totaltimeinseconds = hour * 3600 + minute * 60 + second;

    if (timer) {
        clearInterval(timer);
    }

    timer = setInterval(updateTimer, 1000);
}

function updateTimer() {
    if (totaltimeinseconds <= 0) {
        clearInterval(timer);
        questionNumber = numberOfQuestions;
        document.getElementById("flashcards").innerHTML = "Time's up! Quiz completed.";
        document.getElementById("check").disabled = true;
        document.getElementById("next").disabled = true;
        document.getElementById("userInput").disabled = true;
        document.getElementById("percent").innerHTML = `Percentage: ${Math.round(percent)}%`;
        stopTimer();
        return;
    }

    totaltimeinseconds--;

    let hours = Math.floor(totaltimeinseconds / 3600);
    let minutes = Math.floor((totaltimeinseconds % 3600) / 60);
    let seconds = totaltimeinseconds % 60;

    let time = (hours < 10 ? "0" + hours : hours) + ":" +
               (minutes < 10 ? "0" + minutes : minutes) + ":" +
               (seconds < 10 ? "0" + seconds : seconds);

    document.getElementById("showTimer").innerHTML = time;
}

function stopTimer() {
    if (timer) {
        clearInterval(timer);
    }
}

function startQuiz() {
    startTime = Date.now(); 
    document.getElementById("status").textContent = "Quiz started!";
}

function submitQuiz() {
    if (!startTime) {
        document.getElementById("flashcards").innerHTML = "You need to take the quiz First!"
        return;
    }

    endTime = Date.now(); 
    let timeTaken = (endTime - startTime) / 1000; 
    document.getElementById("timeTaken").innerHTML = `Quiz completed in ${timeTaken} seconds`;
}

function dateDisplay() {
    document.getElementById("check").disabled = true;

    let now = new Date();
    let options = { month: 'numeric', weekday: 'long', day: 'numeric', hour: 'numeric', minute: 'numeric', hour12: true };
    let currentDate = now.toLocaleString(undefined, options);
    document.getElementById("date").innerText = `Submited at: ${currentDate}`; 
}